
// SR11000SampleDlg.cpp : t@C
//

#include "stdafx.h"
#include "SR11000Sample.h"
#include "SR11000SampleDlg.h"
//#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//*************+***************+***************+***************+***************+

//-----+-------+-------+-------+-------+-------+-------+-------+
// Timer ID
#define TIMER_ID_OMR_DATA_RECEIVE				1				// Timer for data acquisition
																// f[^擾p̃^C}


//-----+-------+-------+-------+-------+-------+-------+-------+
// Data form definition (samples)
// [`f[^iTvj

// Management data set ID
// IDǗf[^ݒ
SK_LAYOUT_MANAGE_CONF	TestLayoutManageConf	=
{
	TRUE,										// blEnableId		// TRUE : Use the layout
	{											// IdWindowPrm.
		SKDV_FRONT,									// iFace
		{											// Col.
			1,											// iStart
			2,											// iNumber
			1,											// iStep
		},
		{											// Row.
			1,											// iStart
			1,											// 
			1,											// 
		},
		SKDV_WIN_DIR_TL_RIGHT,						// iDirection
		0,											// (Unavailable)
		{											// Level.
			3,											// iSensitivity
			4,											// iDifference
		},
	},
//	(SKDV_ACTION_SELECT | SKDV_ACTION_STOP),	// dwNgAction
	(SKDV_ACTION_SELECT),						// dwNgAction
	{											// LauoutOpt.
		SKDV_LAYOUT_OPT_NONE,						// iType
		{0},										// (Unavailable)
	}

};

// Setting ID
// IDf[^ݒ
#define TEST_LAYOUT_ID_CNT		2
SK_LAYOUT_ID_CONF		TestLayoutIdConf[TEST_LAYOUT_ID_CNT]	=
{
	{											// Sheet layout A
		{											// LauoutIdPrm
			{//    0     1     2     3     4     5     6     7
				0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		// ucIdData
			},
			{											// iTmCount		Number of timing marks
				65,											// 0 Front		4~155
				0,											// 1 Back		!!If both sides, one side is 0 if more than 4 back side
															//				!!ʂ4ȏȂ痼ʁA0̏ꍇ͕Ж
			},
			2,											// iBarcodeCount
		},
//		SKDV_ACTION_PRINT,								// dwAction
		SKDV_DISABLE,									// iReject
		{												// LauoutOpt.
			SKDV_LAYOUT_OPT_NONE,							// iType
			{0},											// (Unavailable)
		},
	},
	
	{											// Sheet layout B
		{											// LauoutIdPrm
			{//    0     1     2     3     4     5     6     7
				0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		// ucIdData
			},
			{											// iTmCount
				65,											// 0 Front
				0,											// 1 Back
			},
			2,											// iBarcodeCount
		},
//		SKDV_ACTION_PRINT,								// dwAction
		SKDV_DISABLE,									// iReject
		{												// LauoutOpt.
			SKDV_LAYOUT_OPT_NONE,							// iType
			{0},											// 
		},
	},
};

// EBhËݒ
SK_WINDOW_AREA_CONF		TestWindowAreaConf[TEST_LAYOUT_ID_CNT][10]	=
{
	{											// Sheet layout A
		{											// Window 1
			{											// WindowPrm.
				SKDV_FRONT,									// iFace
				{											// Col.
					1,											// iStart	Ps
					8,											// iNumber	Ps
					1,											// iStep	Ps
				},
				{											// Row.
					1,											// iStart	Ps
					1,											// iNumber	Ps
					1,											// iStep	Ps
				},
				SKDV_WIN_DIR_TL_RIGHT,						// iDirection
				SKDV_WIN_PART_OFF,							// iPartition
				{											// Level.
					3,											// iSensitivity
					1,											// iDifference
				},
			},
			{												// WindowCheck.
				0,
				{												// MarkCount.
					0,												// iMin
					9999,											// iMax
				},
			},
//			SKDV_ACTION_SELECT | SKDV_ACTION_STOP,			// dwNgAction
			SKDV_ACTION_SELECT ,							// dwNgAction
			{												// LauoutOpt.
//				SKDV_LAYOUT_OPT_MASK,						// iType
				SKDV_LAYOUT_OPT_NONE,						// iType
				{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
															// }XNp^[
			},
		},

		{0},										// Termination
	},

	{											// Sheet layout B
		{											// Window 1
			{											// WindowPrm.
				SKDV_FRONT,									// iFace
				{											// Col.
					1,											// iStart
					1,											// iNumber
					1,											// iStep
				},
				{												// Row.
					1,											// iStart
					1,											// iNumber
					1,											// iStep
				},
				SKDV_WIN_DIR_TL_RIGHT,						// iDirection
				SKDV_WIN_PART_OFF,							// iPartition
				{											// Level.
					3,											// iSensitivity
					1,											// iDifference
				},
			},
			{												// WindowCheck.
				0,
				{												// MarkCount.
					0,												// iMin
					9999,											// iMax
				},
			},
			SKDV_ACTION_SELECT ,							// dwNgAction
			{												// LauoutOpt.
				SKDV_LAYOUT_OPT_MASK,						// iType
				{0x01,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x10},// 
			},
		},

		{0},										// Termination
	},
};


//*************+***************+***************+***************+***************+


// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CSR11000SampleDlg _CAO




CSR11000SampleDlg::CSR11000SampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSR11000SampleDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	//-----+-------+-------+-------+-------+-------+-------+-------+
	// Member initialization
	// ȍ
	m_hDevice		= NULL;							// Device handle
	m_blReading		= false;						// Reading flag
	//-----+-------+-------+-------+-------+-------+-------+-------+
}

void CSR11000SampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDITLOG_LOG, m_EditLogBoxLog);
	DDX_Control(pDX, IDC_EDITLOG_DATA, m_EditLogBoxData);
}

BEGIN_MESSAGE_MAP(CSR11000SampleDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()

	//-----+-------+-------+-------+-------+-------+-------+-------+
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, &CSR11000SampleDlg::OnBnClickedButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_LAYOUT, &CSR11000SampleDlg::OnBnClickedButtonLayout)
	ON_BN_CLICKED(IDC_BUTTON_READ, &CSR11000SampleDlg::OnBnClickedButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_CANCEL, &CSR11000SampleDlg::OnBnClickedButtonCancel)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, &CSR11000SampleDlg::OnBnClickedButtonDisconnect)

	ON_WM_TIMER()
	//-----+-------+-------+-------+-------+-------+-------+-------+
END_MESSAGE_MAP()


// CSR11000SampleDlg bZ[W nh[

BOOL CSR11000SampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	m_EditLogBoxLog.AddInfo();

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CSR11000SampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CSR11000SampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CSR11000SampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



//*************+***************+***************+***************+***************+
//*************+***************+***************+***************+***************+

void CSR11000SampleDlg::OnOK()
{
}

void CSR11000SampleDlg::OnCancel()
{
	// do not quit while connected
	// ڑ͏IȂ
	if(NULL != m_hDevice)
		return;

	CDialog::OnCancel();
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// Connect{^
void CSR11000SampleDlg::OnBnClickedButtonConnect()
{
	SkDvStatus	Status;

	if(NULL != m_hDevice)	return;								// do not handle being connected
																// ڑ͏Ȃ

	// Version of the library ==================
	// Cũo[W ==================
	SK_DV_MODULE_INFO	ModuleInfo;
	SkDv_GetModuleInfo(&ModuleInfo);
	m_EditLogBoxLog.AddComment("ModuleInfo.szModel  : %s", ModuleInfo.szModel);
	m_EditLogBoxLog.AddComment("ModuleInfo.szVersion: %s", ModuleInfo.szVersion);

	// Connect =================================
	// ڑ ====================================
	Status		= SkDv_OpenSingle(&m_hDevice);
	m_EditLogBoxLog.AddSplit("SkDv_OpenSingle() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// Error handling
		// G[
		return;
	}
	
	// Initialization of the OMR ===============
	// OMȐ =============================
	Status	= SkDv_ReqInit(m_hDevice);
	m_EditLogBoxLog.AddSplit("SkDv_ReqInit() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// Error handling
		// G[
		return;
	}

	// Information acquisition of OMR ==========
	// OMȐ擾 ===========================
	Status	= SkDv_GetInfo(m_hDevice, &m_DvInfo);
	m_EditLogBoxLog.AddSplit("SkDv_GetInfo() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// Error handling
		// G[
		return;
	}

	ShowCount(NULL);											// Number of Display
																// \
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// Layout button
void CSR11000SampleDlg::OnBnClickedButtonLayout()
{
	SkDvStatus	Status;

	if(m_blReading)			return;								// Not during the reading process
																// ǂݎ蒆͏Ȃ

	ShowCount(NULL);											// Number of Display
																// \

	SkDv_ReqClearError(m_hDevice);								// Clear error just in case
																// Ô߂̃G[NA

	// Operation setting of the OMR ============
	// OMR̓ݒ ===========================
	SK_DV_SR3500_MODE			DeviceMode;						// Structure of the operation mode setting
																// 샂[hݒl̍\
	// Acquisition mode of operation
	// 샂[h擾
	Status	= SkDv_GetMode(m_hDevice, &DeviceMode);				// Gets the current mode of operation
																// ݂̓샂[h擾
	m_EditLogBoxLog.AddSplit("SkDv_GetMode() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// Error handling
		// G[
		return;
	}

	//	DeviceMode.dwDisableWarning		= 0							// [jOG[ݒ
	//									| SKDV_WARN_AUTO_REJECT			// G[̎rݒ(tOONŗL)
	//									| SKDV_WARN_HOPPER_EMPTY		// zbpGveBG[oݒ(tOONŗL)
	//									| SKDV_WARN_TM_ERROR			// ^C~O}[NG[oݒ(tOONŗL)
	//									| SKDV_WARN_DF_ERROR			// _utB[hG[oݒ(tOONŗL)
	//									| SKDV_WARN_LEFT_SKEW			// [XL[G[oݒ(tOONŗL)
	//									;
	DeviceMode.MarkSkew.iRow		= SKDV_MARKSKEW_ROW_DISABLE;	// }[NXL[oݒ(L/)
	DeviceMode.MarkSkew.iLevel		= SKDV_MARKSKEW_LEVEL_MIN;		// }[NXL[oxݒ(1`16)
	//	DeviceMode.iPanelOperation		= SKDV_ENABLE;				// plݒ(L/)
	//	DeviceMode.Buzzer.iVol			= SKDV_BUZZER_MIN;			// uU[ʐݒ(/1`5)
	//	DeviceMode.Buzzer.iTone			= SKDV_BUZZER_TONE_A;		// uU[ݒ(1/2/3)
	//	DeviceMode.PSaving.iSleep		= SKDV_SLEEPTIME_MIN;		// X[v^C}\ݒ(/1`60)
	//	DeviceMode.PSaving.iStandby		= SKDV_STANDBYTIME_MIN;		// X^oC^C}[ݒ(/1`60)

	// 샂[hݒ
	Status = SkDv_SetMode(m_hDevice, &DeviceMode);				// ύX샂[hݒ
	m_EditLogBoxLog.AddSplit("SkDv_SetMode() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// G[
		return;
	}

	// }[Nǎݒ ======================
	SK_DV_SR3500MARK_CONF		MarkConf;						// }[Nǂݎ蓮ݒl̍\
	// }[Nǂݎ蓮̎擾
	Status	= SkDv_GetMarkConf(m_hDevice, &MarkConf);
	m_EditLogBoxLog.AddSplit("SkDv_GetMarkConf() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// G[
		return;
	}

	//	MarkConf.iBackSideReading	= SKDV_ENABLE;					// ʓǂݎݒ(L/)
	//	MarkConf.iColumns			= SKDV_COL_MAX;					// ǂݎsݒ(1`48)
	//	MarkConf.iReadingMethod		= SKDV_READ_DIRECT;				// ǂݎݒ([/[//FACOM/ϰ([]ǂݎȂ)/ϰ([]ǂݎ肠)
	//	MarkConf.iCtrlMultiple		= SKDV_READ_EDGE_CTRL_MIN1;		// {ݒ([F1`9 / [F2`9 )
	//	MarkConf.iThicknessType		= SKDV_THICKNESS_90_KG;			// V[gAʐݒ(o/55/72/90/110/135)

	// }[Nǂݎ蓮̐ݒ
	Status	= SkDv_SetMarkConf(m_hDevice, &MarkConf);
	m_EditLogBoxLog.AddSplit("SkDv_SetMarkConf() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// G[
		return;
	}

	// }[NǂݎݒʐMv
	Status	= SkDv_ReqSetMarkConf(m_hDevice);
	m_EditLogBoxLog.AddSplit("SkDv_ReqSetMarkConf() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// G[
		return;
	}

	// v^ݒ ========================
	if(m_DvInfo.Main.dwOption & (SKDV_OPT_UNIT_PRINTER|SKDV_OPT_UNIT_STACKER))
	{

		SK_DV_OPT_PRN_CONF	PrnConf;
		// v^󎚏̈ꊇ擾
		Status	= SkDv_GetPrinterConf(m_hDevice, &PrnConf);
		m_EditLogBoxLog.AddSplit("SkDv_GetPrinterConf() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}

		bool	blEnablePrinter	= (BST_CHECKED == ((CButton*)GetDlgItem(IDC_CHECK_ENABLE_PRINTER))->GetCheck());
		PrnConf.iEnable			= blEnablePrinter ? SKDV_ENABLE : SKDV_DISABLE;	// Enable printer
		//	PrnConf.iStartPos		= 0;								// Print starting position from the leading edge of the sheet
		//	PrnConf.iOrientation	= SKDV_PRINT_ORIENT_0;				// Print orientation
		//	PrnConf.iFontSize		= 40;								// Font size
		//	PrnConf.iFontSpace		= 8;								// Font space
		//	PrnConf.iPrintMode		= SKDV_PRINT_MODE_AFTER_FEED;		// Print mode	SR-11000̘Aǂݎł͖

		// v^󎚏̈ꊇݒ
		Status	= SkDv_SetPrinterConf(m_hDevice, &PrnConf);
		m_EditLogBoxLog.AddSplit("SkDv_SetPrinterConf() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}

		// v^󎚏ݒʐMv
		Status	= SkDv_ReqSetPrinterConf(m_hDevice);
		m_EditLogBoxLog.AddSplit("SkDv_ReqSetPrinterConf() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}

		// Œ󎚕̐ݒ
		char	szFixedString[256];
		GetDlgItemText(IDC_EDIT_PRINT_FIXSTRING, szFixedString, sizeof(szFixedString));
		Status	= SkDv_ReqSetPrintFixString(m_hDevice, szFixedString);
		m_EditLogBoxLog.AddSplit("SkDv_ReqSetPrintFixString() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}

		SK_CONT_FEED_PRN_OPT	PrnOpt;
		char					szStartNum[256];
		GetDlgItemText(IDC_EDIT_PRINT_START_NUM, szStartNum, sizeof(szStartNum));
		PrnOpt.iDigits			= (int)strnlen_s(szStartNum, sizeof(szStartNum));	// AԂ̌F*
		PrnOpt.iStartNumber		= atoi(szStartNum);									// AԂ̃X^[gԍ
		Status	= SkDv_ReqSetContFeedPrint(m_hDevice, &PrnOpt);
		m_EditLogBoxLog.AddSplit("SkDv_ReqSetContFeedPrint() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}

	}

	// o[R[h[_ݒ ================
	if(m_DvInfo.Main.dwOption & (SKDV_OPT_UNIT_BCR))
	{

		SK_DV_OPT_BCR_CONF	BcrConf;

		// o[R[h[_̈ꊇ擾
		Status	= SkDv_GetBcrConf(m_hDevice, &BcrConf);
		m_EditLogBoxLog.AddSplit("SkDv_GetBcrConf() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}

		// VH̔
		switch(m_DvInfo.Bcr.dwOption & SKDV_OPT_BARCODE_MASK)
		{
		case SKDV_OPT_BARCODE_V:
			break;
		case SKDV_OPT_BARCODE_H:
			break;
		default:
			// G[
			return;
		}

		//bool	blEnableBcr		= (BST_CHECKED == ((CButton*)GetDlgItem(IDC_CHECK_ENABLE_BCR))->GetCheck());
		BcrConf.iEnable			= true ? SKDV_ENABLE : SKDV_DISABLE;	// Enable Barcordreader
		//BcrConf.iReadingArea[0]	= SKDV_BCR_READING_AREA_ENTIRE;	// Sǂݎ
		BcrConf.iReadingArea[0]	= 30;							// ǂݎȂ͈[mm]
		BcrConf.iReadingArea[1]	= 50;							// ǂݎ͈[mm]
		BcrConf.iReadingArea[2]	= 100;							// ǂݎȂ͈[mm]
		BcrConf.iReadingArea[3]	= 50;							// ǂݎ͈[mm]
		BcrConf.iReadingArea[4]	= 0;							// I[

		BcrConf.dwEnableBcType	= SKDV_BCR_CODE39					// CODE39̓ǂݎLɂ
								| SKDV_BCR_ITF						// ITF̓ǂݎLɂ
								| SKDV_BCR_NW7						// NW7̓ǂݎLɂ
								| SKDV_BCR_JAN_EAN_UPC;				// JAN,EAN,UPC̓ǂݎLɂ
		BcrConf.CheckDigit.iCode39	= SKDV_BCR_CD_NONE;				// CODE39̃`FbNfWbg		SKDV_BCR_CD_NONE / SKDV_BCR_CD_ENABLE
		BcrConf.CheckDigit.iItf		= SKDV_BCR_CD_NONE;				// ITF̃`FbNfWbg		SKDV_BCR_CD_NONE / SKDV_BCR_CD_ENABLE
		BcrConf.CheckDigit.iNw7		= SKDV_BCR_CD_NONE;				// NW7̃`FbNfWbg		SKDV_BCR_CD_NW7_M16 / SKDV_BCR_CD_NW7_M11 / ...
		BcrConf.Option.iUpcA		= SKDV_BCR_CD_UPC_A_DIGIT_13;
		BcrConf.Option.iUpcE		= SKDV_BCR_CD_UPC_E_ADD_CODE;

		// o[R[h[_̈ꊇݒ
		Status	= SkDv_SetBcrConf(m_hDevice, &BcrConf);
		m_EditLogBoxLog.AddSplit("SkDv_SetBcrConf() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}

		// o[R[h[_ݒʐMv
		Status	= SkDv_ReqSetBcrConf(m_hDevice);
		m_EditLogBoxLog.AddSplit("SkDv_ReqSetBcrConf() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
			return;
		}
	}

	// CAEgݒ ==========================
		// !! CAEg`̐ݒ͎Ԃ|̂
		// !! vOXo[EBhE\ȂǂB
	bool	blError				= false;
	int		iTotalWindowIndex	= 0;
	
	// ID f[^Ǘݒ
	Status	= SkDv_ReqSetLayoutManage(m_hDevice, &TestLayoutManageConf);	// ID f[^Ǘݒ
	m_EditLogBoxLog.AddSplit("SkDv_ReqSetLayoutManage() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
		blError		= true;

	for(int iLayoutId = 0; iLayoutId < TEST_LAYOUT_ID_CNT; iLayoutId++)
	{
		// ID f[^ݒ
		int		iLayoutIdRes	= 0;
		Status	= SkDv_ReqSetLayoutId(m_hDevice, &TestLayoutIdConf[iLayoutId], &iLayoutIdRes);	// ID f[^ݒ
		m_EditLogBoxLog.AddSplit("SkDv_ReqSetLayoutId() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
			blError		= true;
		if(iLayoutId != iLayoutIdRes)											// OMRƂ̐`FbN
			blError		= true;

		for(int iWindowIndex = 0; 0 < TestWindowAreaConf[iLayoutId][iWindowIndex].WindowPrm.Col.iStart; iWindowIndex++)
		{	// !! {TvvOƂāATestWindowAreaConf[][].WindowPrm.Col.iStart0̏ꍇ
			// !! EBhËݒ̏IƂďĂB

			// EBhËf[^ݒ
			int		iWindowIndexRes	= 0;
			Status	= SkDv_ReqSetWindowArea(m_hDevice, &TestWindowAreaConf[iLayoutId][iWindowIndex], &iWindowIndexRes);
			m_EditLogBoxLog.AddSplit("SkDv_ReqSetWindowArea() 0x%08x", Status);
			if(SKDV_STS_SUCCESS != Status)
				blError		= true;
			if(iTotalWindowIndex != iWindowIndexRes)							// OMRƂ̐`FbN
				blError		= true;

			iTotalWindowIndex++;
		}
	}

	// CAEg`I
	int	iLimit		= SKDV_CONT_FEED_LIMIT_NONE;
	Status	= SkDv_ReqSetLayoutManageTerminate(m_hDevice, &iLimit);// CAEg`I
	m_EditLogBoxLog.AddSplit("SkDv_ReqSetLayoutManageTerminate() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
		blError		= true;

	// G[`FbN
	if(blError)
	{
		// G[
		return;
	}
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// Read{^
void CSR11000SampleDlg::OnBnClickedButtonRead()
{
	SkDvStatus				Status;
	DWORD					dwSensor;
	DWORD					dwReqData;

	if(m_blReading)			return;								// ǂݎ蒆͏Ȃ

	// Ô߂̃G[NA
	//SkDv_ReqClearError(m_hDevice);

	// X^bJ̎c`FbN ==================
	Status	= SkDv_ReqGetSensor(m_hDevice, &dwSensor);
	m_EditLogBoxLog.AddSplit("SkDv_ReqGetSensor() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != SKDV_IGNORE_DEVICE_ERROR(Status))
	{
		// G[
		return;
	}
	if((SKDV_SENSOR_BIT_STK_SRPS | SKDV_SENSOR_BIT_STK_MRPS) & dwSensor)
	{
		// rMɎB
		if(IDOK != MessageBox("rMɒ[cĂ܂B\r\nǂݎJn܂B", NULL, MB_OKCANCEL|MB_ICONQUESTION))
			return;
	}

	// AǎJn ============================
	dwReqData				= SKDV_CONT_FEED_REQ_NORMAL			// Aǎiʏj
							;
	Status	= SkDv_ReqContFeedSheet(m_hDevice, dwReqData, SKDV_ENABLE);
//	Status	= SkDv_ReqContFeedSheet(m_hDevice, dwReqData, SKDV_DISABLE);
															// 3DF/[XL[/TMG[̃WFNgw
															//	SKDV_DISABLE : Cr  iij
															//	SKDV_ENABLE  : ZNgriij
	m_EditLogBoxLog.AddSplit("SkDv_ReqContFeedSheet() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// G[
		return;
	}

	// Aṽf[^擾 ==================
	m_iDataCount	= 0;										// f[^NA
	SetDlgItemInt(IDC_EDIT_DATA_COUNT, m_iDataCount);			// f[^
	m_blReading		= true;										// ǂݎ蒆
	SetTimer(TIMER_ID_OMR_DATA_RECEIVE, 100, NULL);				// f[^擾֐̃^C}[N
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// Cancel{^
void CSR11000SampleDlg::OnBnClickedButtonCancel()
{
	if(!m_blReading)		return;								// ǂݎ蒆͏

	SkDv_ReqContFeed_Cancel(m_hDevice);							// LZv
																// !! OMRɃLZv𑗐MAOMR̓LZɈڍsB
																// !! Aǎ̃XbhOMRLZI܂ŒʐMsB
																// !! ăf[^̎擾͌pȂ΂ȂȂB
	m_EditLogBoxLog.AddSplit(		"SkDv_ReqContFeed_Cancel()");
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// Disconnect{^
void CSR11000SampleDlg::OnBnClickedButtonDisconnect()
{
	SkDvStatus	Status;

	if(NULL == m_hDevice)	return;								// ڑ͏Ȃ
	if(m_blReading)			return;								// ǂݎ蒆͏Ȃ

	// ؒf ====================================
	Status		= SkDv_Close(m_hDevice);
	m_EditLogBoxLog.AddSplit("SkDv_Close() 0x%08x", Status);
	if(SKDV_STS_SUCCESS != Status)
	{
		// G[
		return;
	}
	m_hDevice	= NULL;
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// f[^󂯎菈
void CSR11000SampleDlg::OnTimer(UINT_PTR nIDEvent)
{
	if(TIMER_ID_OMR_DATA_RECEIVE == nIDEvent)
	{	// f[^󂯎菈 ==================
		//	!! f[^M[vōsƁA_CAOuȂv\ƂȂׁA
		//	!! ^C}ɂAUbZ[WĉB
		KillTimer(TIMER_ID_OMR_DATA_RECEIVE);						// ^C}UI
																	// !! c̃f[^邩sȂ̂ŁA^C}U~߁AōĊJB

		if(OmrDataReceive())										// f[^擾
		{															// if Aǎ撆cf[^Ȃ
			SetTimer(TIMER_ID_OMR_DATA_RECEIVE, 1, NULL);				// ^C}[̃Zbg
		}
	}

	CDialog::OnTimer(nIDEvent);
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// f[^󂯎菈
bool CSR11000SampleDlg::OmrDataReceive(void)
{
	bool		blContinue		= true;
	SkDvStatus	Status;

	// f[^擾 ==============================
	if(SkDv_ExistDoneData(m_hDevice))
	{															// f[^~ςĂȂ
		// f[^ ------------------------
		Status	= SkDv_PrepareContData(m_hDevice);					// Aǎ̃f[^
		m_EditLogBoxLog.AddSplit("SkDv_PrepareContData() 0x%08x", Status);
		if(SKDV_STS_SUCCESS != Status)
		{
			// G[
		}

		// f[^ԍmF --------------------------
		m_iDataCount++;												// AvǗ̃f[^ԍXV
		if(m_iDataCount != SkDv_GetContDataNumber(m_hDevice))
		{	// !! Avƃ~hEFÃf[^ԍvĂȂB
			// G[
			_ASSERT(false);
		}

		// Aǎ̒[ǎ挋ʎ擾 --------------
		SK_SHEET_RESULT		SheetResult	= {0};
		if(SkDv_GetContDataSheetResult(m_hDevice, &SheetResult))
		{
			//
			//SheetResult.DvStatus;						// ǎ掞̃Xe[^X
			//SheetResult.iTmCount[SKDV_FRONT];			// ^C~O}[N(\)
			//SheetResult.iTmCount[SKDV_BACK ];			// ^C~O}[N()
			//SheetResult.iBarcodeCount;				// o[R[h
			//SheetResult.iId;							// ID F			(0`15 / 99:ΏIDȂ)
			//SheetResult.iPrinted;						// 󎚌				()
			//SheetResult.iStackedId;					// r				()
			//SheetResult.dwResult;						// ʒʒmf[^	()
			//SheetResult.NgWindow.iCount;				// NGEBhȆ
			//SheetResult.NgWindow.iIndex;				// ŏNGEBhEԍ(0~)
			//SheetResult.NgWindow.iPartIndex;			// ŏNGp[eCVԍ(0~)
			//SheetResult.NgWindow.iReason;				// ŏNGR
			//SheetResult.iFinish;						// Iʒmf[^		()
		}

		if((SheetResult.dwResult == SKDV_RESULT_STS_OK)
		|| (SheetResult.dwResult & SKDV_RESULT_STS_WINDOW_NG )
		|| (SheetResult.dwResult & SKDV_RESULT_STS_ID_NG ))
		{
			// Aǎ̃}[Nf[^擾 --------------
			int				iFace;
			SK_DV_MARK_INFO	MarkInfo[SKDV_FACE_NUM]	= {0};
			char			Marks[SKDV_FACE_NUM][SKDV_COL_MAX * SKDV_ROW_MAX]	= {0};
			int				iBufSize[SKDV_FACE_NUM]	= {(SKDV_COL_MAX * SKDV_ROW_MAX),(SKDV_COL_MAX * SKDV_ROW_MAX)};

			for(iFace = SKDV_FRONT; iFace <=SKDV_BACK ; iFace++)
			{
				if(0 == SheetResult.iTmCount[iFace])		continue;
			
				if(SkDv_GetContDataMarks(m_hDevice, iFace, &MarkInfo[iFace], Marks[iFace], &iBufSize[iFace]))
				{
				}
			}
			// !!}[Nf[^̏ōsB
			Sleep(100);			// _~[̃f[^ƂWait

			// ʕW --------------------------------
			SetDlgItemInt(IDC_EDIT_DATA_COUNT, m_iDataCount);			// f[^

			m_EditLogBoxData.AddSplit(	"%3d,0x%08x,TM-F:%3d,TM-B:%3d,ID:%2d,NgCnt:%4d", 
						m_iDataCount, SheetResult.DvStatus, SheetResult.iTmCount[SKDV_FRONT], SheetResult.iTmCount[SKDV_BACK], 
						SheetResult.iId, SheetResult.NgWindow.iCount );
			if(SKDV_RESULT_STS_OK != SheetResult.dwResult)
			{
				m_EditLogBoxData.AddSplit(	"    ->%s", GetStatusMsg(&SheetResult));
			}

			// Aǎ̃o[R[hf[^擾 ----------
			int		iBarcodeCount		= 0;
			char	cBcType;
			int		iDataLen;
			char	szBarcodeData[256];
			if(SkDv_GetContDataBarcodesCount(m_hDevice, &iBarcodeCount))
			{
				m_EditLogBoxData.AddComment(	"  Barcode count:%d", iBarcodeCount);
				for(int iIndex = 1; iIndex < iBarcodeCount+1; iIndex++)
				{
					iDataLen	= sizeof(szBarcodeData);
					ZeroMemory(szBarcodeData, iDataLen);
					if(SkDv_GetContDataBarcodesData(m_hDevice, iIndex, &cBcType, szBarcodeData, &iDataLen))
					{
						if(iDataLen > (sizeof(szBarcodeData)-1))
							szBarcodeData[sizeof(szBarcodeData)-1]	= '\0';
						m_EditLogBoxData.AddComment(	"  %02d:[%c]%s", iIndex, cBcType, szBarcodeData);
					}
				}
			}

		}
		else
		// G[\ --------------------------
		//if((SKDV_RESULT_STS_OK != SheetResult.dwResult) || (SKDV_STS_SUCCESS != SheetResult.DvStatus))
		{
			m_EditLogBoxData.AddSplit(	"%3d,%s", m_iDataCount, GetStatusMsg(&SheetResult));
		}
	}

	// I`FbN ============================
	if(!SkDv_IsContFeedDataFinished(m_hDevice))
	{															// if Aǎ撆cf[^Ȃ
		blContinue		= true;
	}
	else
	{															// el AǎXbhIŎcf[^Ȃ
		blContinue		= false;
		m_blReading		= false;									// ǂݎI

		// ŏIʂ̊mF --------------------------
		SK_CONT_FEED_RESULT		ContFeedResult	= {0};

		SkDv_GetContFeedResult(m_hDevice, &ContFeedResult);
		m_EditLogBoxLog.AddSplit(		"SkDv_GetContFeedResult() 0x%08x", ContFeedResult.DvStatus);
		m_EditLogBoxLog.AddComment(		"    iResult       : %d" , ContFeedResult.iResult);
		switch(ContFeedResult.iResult)
		{
		case SKDV_CFR_NORMAL:			// I
			m_EditLogBoxLog.AddComment(	"    I");
			break;

		case SKDV_CFR_ERROR:			// ُI
			m_EditLogBoxLog.AddComment(	"    ُI");
			break;

		case SKDV_CFR_WINDOW_NG:		// ID/EBhEɂI
			m_EditLogBoxLog.AddComment(	"    ID/EBhEɂI");
			break;

		case SKDV_CFR_CANCEL:			// LZI
			m_EditLogBoxLog.AddComment(	"    LZI");
			break;
		}

		// ̊mF --------------------------
		SK_CONT_FEED_COUNT	ContFeedCount	= {0};
		Status	= SkDv_GetContFeedCount(m_hDevice, &ContFeedCount);
		m_EditLogBoxLog.AddSplit(		"SkDv_GetContFeedCount() 0x%08x", ContFeedResult.DvStatus);
		m_EditLogBoxLog.AddComment(		"    ̌");
		m_EditLogBoxLog.AddComment(		"      {             : %d" , ContFeedCount.iFeed);		// !!m[tB[hJEgɊ܂
		m_EditLogBoxLog.AddComment(		"      ǎ             : %d" , ContFeedCount.iNormal);
		m_EditLogBoxLog.AddComment(		"      󎚓ǎ             : %d" , ContFeedCount.iPrint);
		m_EditLogBoxLog.AddComment(		"      r               : %d" , ContFeedCount.iEject[SKDV_RESULT_STK_NONE]);
		m_EditLogBoxLog.AddComment(		"      CX^bJr   : %d" , ContFeedCount.iEject[SKDV_RESULT_STK_MAIN]);
		m_EditLogBoxLog.AddComment(		"      ZNgX^bJr : %d" , ContFeedCount.iEject[SKDV_RESULT_STK_SELECTION]);
		m_EditLogBoxLog.AddComment(		"      r           : %d" , ContFeedCount.iUntreated);	// !!XL[/DF/EBhENGɖǂŔr

		// eXg ------------------------------------------->
		//Status	= SkDv_PrepareContData(m_hDevice);					// Aǎ̃f[^
		//m_EditLogBoxLog.AddSplit("SkDv_PrepareContData() 0x%08x", Status);
		//int				iFace;
		//SK_DV_MARK_INFO	MarkInfo[SKDV_FACE_NUM]	= {0};
		//char			Marks[SKDV_FACE_NUM][SKDV_COL_MAX * SKDV_ROW_MAX]	= {0};
		//int				iBufSize[SKDV_FACE_NUM]	= {(SKDV_COL_MAX * SKDV_ROW_MAX),(SKDV_COL_MAX * SKDV_ROW_MAX)};

		//for(iFace = SKDV_FRONT; iFace <=SKDV_BACK ; iFace++)
		//{
		//	if(SkDv_GetContDataMarks(m_hDevice, iFace, &MarkInfo[iFace], Marks[iFace], &iBufSize[iFace]))
		//	{
		//	}
		//}
		// <------------------------------------------- eXg

		// zbp --------------------------
		// !! OMRFWJȂ̂ŁAꉞzbpオĂ牺Ă݂B
		//DWORD	dwSensor	= 0;
		//SkDv_ReqGetSensor(m_hDevice, &dwSensor);				// ZT擾
		//if(0 == (dwSensor & SKDV_SENSOR_BIT_DWPS))
		//{
		//	SkDv_ReqMoveHopper(m_hDevice, SKDV_HOPPER_DOWN);		// zbp
		//}
	}

	// A^Cł̏̕\ ==========
	SK_CONT_FEED_COUNT	ContFeedCount	= {0};
	Status	= SkDv_GetContFeedCount(m_hDevice, &ContFeedCount);
	if(SKDV_STS_SUCCESS != Status)
	{
		// G[
		ShowCount(NULL);
	}
	else
	{
		ShowCount(&ContFeedCount);									// \
	}

	return blContinue;
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// EBhEɌʂ̃JEg\
void	CSR11000SampleDlg::ShowCount(SK_CONT_FEED_COUNT* pContFeedCount)
{
	if(NULL == pContFeedCount)
	{																		// w肪΃NA
		SetDlgItemText(IDC_EDIT_FEED_COUNT,			"");						// ǎ文
		SetDlgItemText(IDC_EDIT_NORMAL_COUNT,		"");						// 햇
		SetDlgItemText(IDC_EDIT_MAIN_STK_COUNT,		"");						// CX^bJ
		SetDlgItemText(IDC_EDIT_SELECT_STK_COUNT,	"");						// ZNgX^bJ
	}
	else
	{																		// w肪̂Ŗ\
		SetDlgItemInt(IDC_EDIT_FEED_COUNT,			pContFeedCount->iFeed);		// ǎ文
		SetDlgItemInt(IDC_EDIT_NORMAL_COUNT,		pContFeedCount->iNormal);	// 햇
		SetDlgItemInt(IDC_EDIT_MAIN_STK_COUNT,		pContFeedCount->iEject[SKDV_RESULT_STK_MAIN]);		// CX^bJ
		SetDlgItemInt(IDC_EDIT_SELECT_STK_COUNT,	pContFeedCount->iEject[SKDV_RESULT_STK_SELECTION]);	// ZNgX^bJ
	}
}



//-----+-------+-------+-------+-------+-------+-------+-------+
// [ʁiXe[^Xj\pɕϊĕԂ
char*	CSR11000SampleDlg::GetStatusMsg(SK_SHEET_RESULT* pSheetResult)
{
	static char	szTemp[256];
	
	// [ʂ̕񐶐
	if(pSheetResult->dwResult == (SKDV_RESULT_STS_ID_NG))
	{
		strcpy_s(szTemp, sizeof(szTemp), "IDmf=");
		switch(pSheetResult->iIdResult)
		{
		case SKDV_RESULT_ID_TM_CNT_DIFF_F	:		strcat_s(szTemp, sizeof(szTemp), "\ʃ^C~O}[Nsv ");	break;
		case SKDV_RESULT_ID_TM_CNT_DIFF_B	:		strcat_s(szTemp, sizeof(szTemp), "ʃ^C~O}[Nsv ");	break;
		case SKDV_RESULT_ID_TM_CNT_DIFF_FB	:		strcat_s(szTemp, sizeof(szTemp), "ʃ^C~O}[Nsv ");	break;
		case SKDV_RESULT_ID_ID_NONE			:		strcat_s(szTemp, sizeof(szTemp), "CAEgIDSsv ");	break;
		case SKDV_RESULT_ID_BC_CNT_DIFF		:		strcat_s(szTemp, sizeof(szTemp), "o[R[hf[^sv ");	break;
		case SKDV_RESULT_ID_ID_ORDER_NG		:		strcat_s(szTemp, sizeof(szTemp), "CAEgIDNG ");	break;
		}
	}
	else if(pSheetResult->dwResult == (SKDV_RESULT_STS_WINDOW_NG))
	{
		strcpy_s(szTemp, sizeof(szTemp), "EBhEmf=");
		switch(pSheetResult->NgWindow.iReason)
		{
		case SKDV_RESULT_REASON_MARK_COUNT_LOWER	:		strcat_s(szTemp, sizeof(szTemp), "}[NȂ ");	break;
		case SKDV_RESULT_REASON_MARK_COUNT_UPPER	:		strcat_s(szTemp, sizeof(szTemp), "}[N ");	break;
		case SKDV_RESULT_REASON_MARK_DISAGREE		:		strcat_s(szTemp, sizeof(szTemp), "Œf[^sv ");	break;
		case SKDV_RESULT_REASON_CHECK_DIGIT_NG		:		strcat_s(szTemp, sizeof(szTemp), "`FbNfWbgNG ");	break;
		case SKDV_RESULT_REASON_ASCENDING_ORDER_NG	:		strcat_s(szTemp, sizeof(szTemp), "͈̓`FbNij ");	break;
		case SKDV_RESULT_REASON_DESCENDING_ORDER_NG	:		strcat_s(szTemp, sizeof(szTemp), "͈̓`FbNi~j ");	break;
		case SKDV_RESULT_REASON_RANGE_CHECK_NG		:		strcat_s(szTemp, sizeof(szTemp), "͈̓`FbNij ");	break;
		}
	}
	else if(pSheetResult->dwResult == (SKDV_RESULT_STS_ERROR_STOP))
	{
		strcpy_s(szTemp, sizeof(szTemp), "ُI");
	}
	else if(pSheetResult->dwResult == (SKDV_RESULT_STS_WINDOW_NG | SKDV_RESULT_STS_ERROR_STOP))
	{
		strcpy_s(szTemp, sizeof(szTemp), "EBhEmfňُI");
	}
	else if(pSheetResult->dwResult & SKDV_RESULT_STS_ERROR_EJECT)
	{
		strcpy_s(szTemp, sizeof(szTemp), "G[ɂAǂݎ炸ɔr");
	}
	else
	{
		strcpy_s(szTemp, sizeof(szTemp), "");
	}

	// Xe[^XȊOȂA񐶐
	if(SKDV_STS_SUCCESS != pSheetResult->DvStatus)
	{
		char	szStatusMsg[256];
		sprintf_s(szStatusMsg, sizeof(szStatusMsg), " (Status:0x%08x)", pSheetResult->DvStatus);
		strcat_s(szTemp, sizeof(szTemp), szStatusMsg);

		// G[𕶎ɕϊ
		switch(pSheetResult->DvStatus & SKDV_STS_DEVICE_STA_MASK)
		{
		case SKDV_STS_DEVICE_ST_A1:		strcat_s(szTemp, sizeof(szTemp), "A1:Memory Error 1 (Internal Memory Error)");	break;
		case SKDV_STS_DEVICE_ST_A2:		strcat_s(szTemp, sizeof(szTemp), "A2:Memory Error 2 (Internal Memory Error)");	break;
		case SKDV_STS_DEVICE_ST_A3:		strcat_s(szTemp, sizeof(szTemp), "A3:Hopper Drive Error");	break;
		case SKDV_STS_DEVICE_ST_A4:		strcat_s(szTemp, sizeof(szTemp), "A4:Download Error (Main Unit)");	break;
		case SKDV_STS_DEVICE_ST_A5:		strcat_s(szTemp, sizeof(szTemp), "A5:Sensor Type Error");	break;
		case SKDV_STS_DEVICE_ST_A6:		strcat_s(szTemp, sizeof(szTemp), "A6:Option Error");	break;
		case SKDV_STS_DEVICE_ST_A8:		strcat_s(szTemp, sizeof(szTemp), "A8:Power Supply Error");	break;
		case SKDV_STS_DEVICE_ST_B1:		strcat_s(szTemp, sizeof(szTemp), "B1:Communication Error");	break;
		case SKDV_STS_DEVICE_ST_B2:		strcat_s(szTemp, sizeof(szTemp), "B2:Internal COM Error (No response Read Sensor)");	break;
		case SKDV_STS_DEVICE_ST_B3:		strcat_s(szTemp, sizeof(szTemp), "B3:Memory Error (in Read Sensor) ");	break;
		case SKDV_STS_DEVICE_ST_B4:		strcat_s(szTemp, sizeof(szTemp), "B4:Adjust Value Error (Read Sensor)");	break;
		case SKDV_STS_DEVICE_ST_B5:		strcat_s(szTemp, sizeof(szTemp), "B5:Download Error (Read Sensor)  ");	break;
		case SKDV_STS_DEVICE_ST_B6:		strcat_s(szTemp, sizeof(szTemp), "B6:Internal Error (Read Sensor)");	break;
		case SKDV_STS_DEVICE_ST_B7:		strcat_s(szTemp, sizeof(szTemp), "B7:Version Error(Read Sensor) ");	break;
		case SKDV_STS_DEVICE_ST_C1:		strcat_s(szTemp, sizeof(szTemp), "C1:Communication Error (Barcode Unit)");	break;
		case SKDV_STS_DEVICE_ST_C2:		strcat_s(szTemp, sizeof(szTemp), "C2:Internal COM Error (Barcode Unit)");	break;
		case SKDV_STS_DEVICE_ST_C3:		strcat_s(szTemp, sizeof(szTemp), "C3:Memory Error (Barcode Unit)");	break;
		case SKDV_STS_DEVICE_ST_C4:		strcat_s(szTemp, sizeof(szTemp), "C4:Sensor Error (Barcode Unit)");	break;
		case SKDV_STS_DEVICE_ST_C5:		strcat_s(szTemp, sizeof(szTemp), "C5:Download Error (Barcode Unit)");	break;
		case SKDV_STS_DEVICE_ST_C6:		strcat_s(szTemp, sizeof(szTemp), "C6:Internal Error (Barcode Unit)");	break;
		case SKDV_STS_DEVICE_ST_C7:		strcat_s(szTemp, sizeof(szTemp), "C7:Version Error (Barcode Unit)");	break;
		case SKDV_STS_DEVICE_ST_D1:		strcat_s(szTemp, sizeof(szTemp), "D1:Communication Error(Printer Unit)");	break;
		case SKDV_STS_DEVICE_ST_D2:		strcat_s(szTemp, sizeof(szTemp), "D2:Internal COM Error (Printer Unit)");	break;
		case SKDV_STS_DEVICE_ST_D3:		strcat_s(szTemp, sizeof(szTemp), "D3:Memory Error (Printer Unit)");	break;
		case SKDV_STS_DEVICE_ST_D4:		strcat_s(szTemp, sizeof(szTemp), "D4:Download Error (Printer Unit)");	break;
		case SKDV_STS_DEVICE_ST_D5:		strcat_s(szTemp, sizeof(szTemp), "D5:Internal Error (Printer Unit)");	break;
		case SKDV_STS_DEVICE_ST_D6:		strcat_s(szTemp, sizeof(szTemp), "D6:Version Error (Printer Unit)");	break;
		case SKDV_STS_DEVICE_ST_E1:		strcat_s(szTemp, sizeof(szTemp), "E1:Communication Error (Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_E2:		strcat_s(szTemp, sizeof(szTemp), "E2:Internal COM Error (Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_E3:		strcat_s(szTemp, sizeof(szTemp), "E3:Memory Error (Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_E4:		strcat_s(szTemp, sizeof(szTemp), "E4:Download Error (Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_E5:		strcat_s(szTemp, sizeof(szTemp), "E5:Internal Error (Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_E6:		strcat_s(szTemp, sizeof(szTemp), "E6:Version Error (Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_J1:		strcat_s(szTemp, sizeof(szTemp), "J1:Download Error (Image Sensor Unit) ");	break;
		case SKDV_STS_DEVICE_ST_J2:		strcat_s(szTemp, sizeof(szTemp), "J2:Internal COM Error 1 (Image Sensor Unit)");	break;
		case SKDV_STS_DEVICE_ST_J3:		strcat_s(szTemp, sizeof(szTemp), "J3:Internal COM Error 1 (Image Sensor Unit)");	break;
		case SKDV_STS_DEVICE_ST_J4:		strcat_s(szTemp, sizeof(szTemp), "J4:Memory Error 1 (Image Sensor Unit / Flash Rom Read Error) ");	break;
		case SKDV_STS_DEVICE_ST_J5:		strcat_s(szTemp, sizeof(szTemp), "J5:Memory Error 2 (Image Sensor Unit / Flash Rom Load Error)  ");	break;
		case SKDV_STS_DEVICE_ST_J6:		strcat_s(szTemp, sizeof(szTemp), "J6:Memory Error 3 (Image Sensor Unit / E2PROM Read Error)");	break;
		case SKDV_STS_DEVICE_ST_J7:		strcat_s(szTemp, sizeof(szTemp), "J7:Memory Error 4 (Image Sensor Unit / E2PROM Load Error) ");	break;
		case SKDV_STS_DEVICE_ST_J8:		strcat_s(szTemp, sizeof(szTemp), "J8:IC Error (Image Sensor Unit)");	break;
		case SKDV_STS_DEVICE_ST_J9:		strcat_s(szTemp, sizeof(szTemp), "J9:CIS Error (Image Sensor Unit)");	break;
		case SKDV_STS_DEVICE_ST_K1:		strcat_s(szTemp, sizeof(szTemp), "K1:FPGA Error (Image Sensor Unit) ");	break;
		case SKDV_STS_DEVICE_ST_K2:		strcat_s(szTemp, sizeof(szTemp), "K2:Power Supply Error (Image Sensor Unit) ");	break;
		case SKDV_STS_DEVICE_ST_K3:		strcat_s(szTemp, sizeof(szTemp), "K3:Version Error (Image Sensor Unit) ");	break;
		case SKDV_STS_DEVICE_ST_F5:		strcat_s(szTemp, sizeof(szTemp), "F5:Command Error");	break;
		case SKDV_STS_DEVICE_ST_F6:		strcat_s(szTemp, sizeof(szTemp), "F6:Parameter Error");	break;
		case SKDV_STS_DEVICE_ST_F7:		strcat_s(szTemp, sizeof(szTemp), "F7:Protocol Error");	break;
		case SKDV_STS_DEVICE_ST_G1:		strcat_s(szTemp, sizeof(szTemp), "G1:Cover Open ");	break;
		case SKDV_STS_DEVICE_ST_G2:		strcat_s(szTemp, sizeof(szTemp), "G2:Stacker Unit Cover Open");	break;
		case SKDV_STS_DEVICE_ST_H1:		strcat_s(szTemp, sizeof(szTemp), "H1:No Feed");	break;
		case SKDV_STS_DEVICE_ST_H2:		strcat_s(szTemp, sizeof(szTemp), "H2:Jam at Paper Feeding Detection Sensor ");	break;
		case SKDV_STS_DEVICE_ST_H3:		strcat_s(szTemp, sizeof(szTemp), "H3:Jam at Reading Start Detection Sensor ");	break;
		case SKDV_STS_DEVICE_ST_H4:		strcat_s(szTemp, sizeof(szTemp), "H4:Jam at Main body Paper Discharge Detection Sensor");	break;
		case SKDV_STS_DEVICE_ST_I1:		strcat_s(szTemp, sizeof(szTemp), "I1:Jam at Printing Start Detection Sensor");	break;
		case SKDV_STS_DEVICE_ST_I2:		strcat_s(szTemp, sizeof(szTemp), "I2:Jam at Main Paper Discharge Sensor");	break;
		case SKDV_STS_DEVICE_ST_I3:		strcat_s(szTemp, sizeof(szTemp), "I3:Jam at Selected (Reject) Paper Discharge Sensor");	break;
		case SKDV_STS_DEVICE_ST_P1:		strcat_s(szTemp, sizeof(szTemp), "P1:Back Surface Reading Unit Unconnected");	break;
		case SKDV_STS_DEVICE_ST_P2:		strcat_s(szTemp, sizeof(szTemp), "P2:Barcode Unit Unconnected");	break;
		case SKDV_STS_DEVICE_ST_P3:		strcat_s(szTemp, sizeof(szTemp), "P3:Printer Unit Unconnected");	break;
		case SKDV_STS_DEVICE_ST_P4:		strcat_s(szTemp, sizeof(szTemp), "P4:Select Stacker Unit Unconnected");	break;
		case SKDV_STS_DEVICE_ST_P5:		strcat_s(szTemp, sizeof(szTemp), "P5:Image Sensor Unit Unconnected");	break;
		case SKDV_STS_DEVICE_ST_Q1:		strcat_s(szTemp, sizeof(szTemp), "Q1:Sheet Empty");	break;
		case SKDV_STS_DEVICE_ST_Q2:		strcat_s(szTemp, sizeof(szTemp), "Q2:Double Feed Error");	break;
		case SKDV_STS_DEVICE_ST_Q3:		strcat_s(szTemp, sizeof(szTemp), "Q3:Left End Skew Error");	break;
		case SKDV_STS_DEVICE_ST_Q4:		strcat_s(szTemp, sizeof(szTemp), "Q4:Mark Skew Error");	break;
		case SKDV_STS_DEVICE_ST_R1:		strcat_s(szTemp, sizeof(szTemp), "R1:Hopper Stops");	break;
		case SKDV_STS_DEVICE_ST_R2:		strcat_s(szTemp, sizeof(szTemp), "R2:Drowing Out Error");	break;
		case SKDV_STS_DEVICE_ST_R3:		strcat_s(szTemp, sizeof(szTemp), "R3:Timeout");	break;
		case SKDV_STS_DEVICE_ST_R4:		strcat_s(szTemp, sizeof(szTemp), "R4:Timing Mark Error");	break;
		case SKDV_STS_DEVICE_ST_R5:		strcat_s(szTemp, sizeof(szTemp), "R5:Setting Error");	break;
		case SKDV_STS_DEVICE_ST_R6:		strcat_s(szTemp, sizeof(szTemp), "R6:Memory Overflow");	break;
		case SKDV_STS_DEVICE_ST_S2:		strcat_s(szTemp, sizeof(szTemp), "S2:Black Level Error");	break;
		case SKDV_STS_DEVICE_ST_S3:		strcat_s(szTemp, sizeof(szTemp), "S3:Read Sensor Stain Error");	break;
		case SKDV_STS_DEVICE_ST_S4:		strcat_s(szTemp, sizeof(szTemp), "S4:Skew Sensor Stain Error");	break;
		case SKDV_STS_DEVICE_ST_T1:		strcat_s(szTemp, sizeof(szTemp), "T1:Form Left In Hopper");	break;
		case SKDV_STS_DEVICE_ST_T2:		strcat_s(szTemp, sizeof(szTemp), "T2:Form Left in Reading Sensor");	break;
		case SKDV_STS_DEVICE_ST_T3:		strcat_s(szTemp, sizeof(szTemp), "T3:Form Left in End of Main Body");	break;
		case SKDV_STS_DEVICE_ST_T4:		strcat_s(szTemp, sizeof(szTemp), "T4:Form Left in Printer Printing Detection Sensor");	break;
		case SKDV_STS_DEVICE_ST_T5:		strcat_s(szTemp, sizeof(szTemp), "T5:Form Left in Main paper Discharge Sensor");	break;
		case SKDV_STS_DEVICE_ST_T6:		strcat_s(szTemp, sizeof(szTemp), "T6:Form Left in Selected (Reject) Paper Discharge Sensor");	break;
		case SKDV_STS_DEVICE_ST_Z1:		strcat_s(szTemp, sizeof(szTemp), "Z1:Density adjust Skew Error");	break;
		case SKDV_STS_DEVICE_ST_Z2:		strcat_s(szTemp, sizeof(szTemp), "Z2:Density adjust Sheet Error");	break;
		case SKDV_STS_DEVICE_ST_Z3:		strcat_s(szTemp, sizeof(szTemp), "Z3:Dirt Density adjust Sheet");	break;
		case SKDV_STS_DEVICE_ST_Z4:		strcat_s(szTemp, sizeof(szTemp), "Z4:Density adjust Error");	break;
		case SKDV_STS_DEVICE_ST_Z5:		strcat_s(szTemp, sizeof(szTemp), "Z5:RDPS adjust Error");	break;
		case SKDV_STS_DEVICE_ST_Z6:		strcat_s(szTemp, sizeof(szTemp), "Z6:Skew Sensor Adjust Error");	break;
		case SKDV_STS_DEVICE_ST_Z7:		strcat_s(szTemp, sizeof(szTemp), "Z7:DF sensor Adjust Error");	break;

		//SR-11000ǉ
		case SKDV_STS_DEVICE_ST_E7:		strcat_s(szTemp, sizeof(szTemp), "E7:Drive Error (Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_H5:		strcat_s(szTemp, sizeof(szTemp), "H5:Too few Paper gap");	break;
		case SKDV_STS_DEVICE_ST_I4:		strcat_s(szTemp, sizeof(szTemp), "I4:Jam at Upper part Paper Detection Sensors");	break;
		case SKDV_STS_DEVICE_ST_I5:		strcat_s(szTemp, sizeof(szTemp), "I5:Jam at Bottom part Paper Detection Sensors");	break;
		case SKDV_STS_DEVICE_ST_I6:		strcat_s(szTemp, sizeof(szTemp), "I6:Too few Paper gap(Stacker Unit)");	break;
		case SKDV_STS_DEVICE_ST_R7:		strcat_s(szTemp, sizeof(szTemp), "R7:USB Connection Error");	break;


		default:						strcat_s(szTemp, sizeof(szTemp), "Other Error");	break;
		}
	}
	
	return(szTemp);
}




